-- Macro_Scripts File
-- Purpose:  define action for each creatable Standard and Extended Primitive objects to hook up to the create main menu (or quads)

/*
Revision History

	21 jan 2004, Pierre-Felix Breton
		turning some primitives back on
		
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------
-- Standard Primitives

--------------------------------------------------------------------------------------------
macroScript Box 
            category:~BOX_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~BOX_TOOLTIP~ 
			ButtonText:~BOX_BUTTONTEXT~
            icon:#("standard", 1)
(
	on execute do StartObjectCreation Box
        on isChecked return (mcrUtils.IsCreating Box)
)

--------------------------------------------------------------------------------------------
macroScript Cone 
            category:~CONE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~CONE_TOOLTIP~ 
			ButtonText:~CONE_BUTTONTEXT~
            icon:#("Standard",6)
(
	on execute do StartObjectCreation Cone
        on isChecked return (mcrUtils.IsCreating Cone)
)

--------------------------------------------------------------------------------------------
macroScript Sphere
            category:~SPHERE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~SPHERE_TOOLTIP~
			ButtonText:~SPHERE_BUTTONTEXT~ 
            icon:#("standard", 2)
(
	on execute do StartObjectCreation Sphere 
        on isChecked return (mcrUtils.IsCreating Sphere)
)

--------------------------------------------------------------------------------------------
macroScript GeoSphere 
            category:~GEOSPHERE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~GEOSPHERE_TOOLTIP~
			ButtonText:~GEOSPHERE_BUTTONTEXT~ 
            icon:#("Standard",7) 
(
	on execute do (Try(StartObjectCreation GeoSphere) Catch() )
        on isChecked return (mcrUtils.IsCreating GeoSphere)
)

--------------------------------------------------------------------------------------------
macroScript Cylinder 
            category:~CYLINDER_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~CYLINDER_TOOLTIP~
			ButtonText:~CYLINDER_BUTTONTEXT~ 
            icon:#("Standard",3)
(
	on execute do StartObjectCreation Cylinder 
        on isChecked return (mcrUtils.IsCreating Cylinder)
)

--------------------------------------------------------------------------------------------
macroScript Tube 
            category:~TUBE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~TUBE_TOOLTIP~
			ButtonText:~TUBE_BUTTONTEXT~ 
            icon:#("Standard",8)
(
	on execute do StartObjectCreation Tube 
        on isChecked return (mcrUtils.IsCreating Tube)
)


-------------------------------------------------------------------------------
macroScript Torus 
            category:~TORUS_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~TORUS_TOOLTIP~
			ButtonText:~TORUS_BUTTONTEXT~ 
            icon:#("Standard",4)
(
	on execute do StartObjectCreation Torus 
        on isChecked return (mcrUtils.IsCreating Torus)
)


--------------------------------------------------------------------------------------------
macroScript Pyramid 
            category:~PYRAMID_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~PYRAMID_TOOLTIP~
			ButtonText:~PYRAMID_BUTTONTEXT~ 
            icon:#("Standard",9)
(
	on execute do StartObjectCreation Pyramid 
        on isChecked return (mcrUtils.IsCreating Pyramid)
)

--------------------------------------------------------------------------------------------
macroScript Torus_Knot 
            category:~TORUS_KNOT_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~TORUS_KNOT_TOOLTIP~
			ButtonText:~TORUS_KNOT_BUTTONTEXT~ 
            icon:#("Extended",7)
(
	on execute do StartObjectCreation Torus_Knot 
        on isChecked return (mcrUtils.IsCreating Torus_Knot)
)

--------------------------------------------------------------------------------------------
macroScript Quadpatch 
category:~QUADPATCH_CATEGORY~ 
internalCategory:"Objects Patch"
            tooltip:~QUADPATCH_TOOLTIP~
			ButtonText:~QUADPATCH_BUTTONTEXT~ 
            icon:#("Patches",1)
(	
	on execute do StartObjectCreation Quadpatch
        on isChecked return (mcrUtils.IsCreating Quadpatch)
)

--------------------------------------------------------------------------------------------
macroScript Tripatch 
category:~TRIPATCH_CATEGORY~ 
internalCategory:"Objects Patch"
            tooltip:~TRIPATCH_TOOLTIP~
			ButtonText:~TRIPATCH_BUTTONTEXT~ 
            icon:#("Patches",2)
(
	on execute do StartObjectCreation Tripatch 
        on isChecked return (mcrUtils.IsCreating Tripatch)
)



--------------------------------------------------------------------------------------------
macroScript plane 
            category:~PLANE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~PLANE_TOOLTIP~
			ButtonText:~PLANE_BUTTONTEXT~ 
            icon:#("Standard",10)
(
	on execute do StartObjectCreation Plane
        on isChecked return (mcrUtils.IsCreating Plane)
)

--------------------------------------------------------------------------------------------
macroScript TextPlus 
            category:~TEXTPLUS_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~TEXTPLUS_TOOLTIP~
			ButtonText:~TEXTPLUS_BUTTONTEXT~ 
            icon:#("Standard",11) 
(
	on execute do (Try(StartObjectCreation TextPlus) Catch() )
        on isChecked return (mcrUtils.IsCreating TextPlus)
)

--------------------------------------------------------------------------------------------
macroScript L_Ext 
            category:~L_EXT_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~L_EXT_TOOLTIP~
			ButtonText:~L_EXT_BUTTONTEXT~ 
            icon:#("Extended",10)
(
	on execute do StartObjectCreation L_Ext
        on isChecked return (mcrUtils.IsCreating L_Ext)
)

--------------------------------------------------------------------------------------------
macroScript Spindle 
            category:~SPINDLE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~SPINDLE_TOOLTIP~
			ButtonText:~SPINDLE_BUTTONTEXT~ 
            icon:#("Extended",4)
(
	on execute do StartObjectCreation Spindle 
        on isChecked return (mcrUtils.IsCreating Spindle)
)

--------------------------------------------------------------------------------------------
macroScript ChamferBox 
            category:~CHAMFERBOX_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~CHAMFERBOX_TOOLTIP~
			ButtonText:~CHAMFERBOX_BUTTONTEXT~ 
            icon:#("Extended",2)
(	
	on execute do StartObjectCreation ChamferBox 
        on isChecked return (mcrUtils.IsCreating ChamferBox)
)

--------------------------------------------------------------------------------------------
macroScript OilTank 
            category:~OILTANK_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~OILTANK_TOOLTIP~
			buttontext:~OILTANK_BUTTONTEXT~ 
            icon:#("Extended",3)
(	
	on execute do StartObjectCreation OilTank 
        on isChecked return (mcrUtils.IsCreating OilTank)
)

--------------------------------------------------------------------------------------------
macroScript RingWave 
            category:~RINGWAVE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~RINGWAVE_TOOLTIP~
			ButtonText:~RINGWAVE_BUTTONTEXT~ 
            icon:#("Extended",6)
(
	on execute do StartObjectCreation RingWave 
        on isChecked return (mcrUtils.IsCreating RingWave)
)

--------------------------------------------------------------------------------------------
macroScript C_Ext 
            category:~C_EXT_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~C_EXT_TOOLTIP~
			ButtonText:~C_EXT_BUTTONTEXT~ 
            icon:#("Extended",11)
(
	on execute do StartObjectCreation C_Ext 
        on isChecked return (mcrUtils.IsCreating C_Ext)
)

--------------------------------------------------------------------------------------------
macroScript Gengon 
            category:~GENGON_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~GENGON_TOOLTIP~
			ButtonText:~GENGON_BUTTONTEXT~ 
            icon:#("Extended",5)
(
	on execute do StartObjectCreation Gengon 
        on isChecked return (mcrUtils.IsCreating Gengon)
)

--------------------------------------------------------------------------------------------
macroScript Prism 
            category:~PRISM_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~PRISM_TOOLTIP~ 
			ButtonText:~PRISM_BUTTONTEXT~
            icon:#("Extended",12) 
(
	on execute do StartObjectCreation Prism 
        on isChecked return (mcrUtils.IsCreating Prism)
)

--------------------------------------------------------------------------------------------
macroScript Capsule 
            category:~CAPSULE_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~CAPSULE_TOOLTIP~
			ButtonText:~CAPSULE_BUTTONTEXT~ 
            icon:#("Extended",9)
(
	on execute do StartObjectCreation Capsule 
        on isChecked return (mcrUtils.IsCreating Capsule)
)



--------------------------------------------------------------------------------------------
macroScript ChamferCyl 
            category:~CHAMFERCYL_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~CHAMFERCYL_TOOLTIP~
			ButtonText:~CHAMFERCYL_BUTTONTEXT~ 
            icon:#("Extended",8)
(
	on execute do StartObjectCreation ChamferCyl 
        on isChecked return (mcrUtils.IsCreating ChamferCyl)
)


--------------------------------------------------------------------------------------------
macroScript Teapot 
            category:~TEAPOT_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~TEAPOT_TOOLTIP~
			ButtonText:~TEAPOT_BUTTONTEXT~ 
            icon:#("Standard",5)
(
	on execute do StartObjectCreation Teapot 
        on isChecked return (mcrUtils.IsCreating Teapot)
)

--------------------------------------------------------------------------------------------
macroScript Hedra
            category:~HEDRA_CATEGORY~ 
            internalCategory:"Objects Primitives" 
            tooltip:~HEDRA_TOOLTIP~
			ButtonText:~HEDRA_BUTTONTEXT~ 
            icon:#("Extended",1)
(
	on execute do StartObjectCreation Hedra 
        on isChecked return (mcrUtils.IsCreating Hedra)
)
--------------------------------------------------------------------------------------------
macroScript Hose 
            category:~HOSE_CATEGORY~
            internalCategory:"Objects Primitives" 
            tooltip:~HOSE_TOOLTIP~
			ButtonText:~HOSE_BUTTONTEXT~ 
(
	on execute do StartObjectCreation Hose 
        on isChecked return (mcrUtils.IsCreating Hose)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAU8p6UkT7pU3lh9shqKCddXhgH3CTogrsc
-- EJ2qD72TGBNq1QUtnnz0aCsVtdEWx9O9/GRnhN7goeyzXIhkgWk4uQUCoS+Lqy7k
-- +lCXUvtt74+O5caaQSj1Uq3NBulqQfHNUCp3oDoT3SDBQ+a/A3F9t2Klu9ZiChAC
-- A1MFCNEsSpZFBhWj0mikQYSwahoO3ISgZQH7Yu1oT6SnRoVqqoGByKH89v+YoIDJ
-- d3BFwK+IrtcdaG60NawiBARQXNLsCgucfm6ViylT2HES3BdaD2Bq43B+JcJJe8Uu
-- LL5t7luBX23QVrSxrStYFjIRoNP9vZbkr8hSnDCTxTa3oFzj3BG4
-- -----END-SIGNATURE-----